/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigRational;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RecSolvablePolynomialRing;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import edu.jas.poly.WeylRelationsIterated;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class RecSolvablePolynomialTest
extends TestCase {
    RecSolvablePolynomial<BigRational> a;
    RecSolvablePolynomial<BigRational> b;
    RecSolvablePolynomial<BigRational> c;
    RecSolvablePolynomial<BigRational> d;
    RecSolvablePolynomial<BigRational> e;
    RecSolvablePolynomial<BigRational> f;
    RecSolvablePolynomial<BigRational> x1;
    RecSolvablePolynomial<BigRational> x2;
    int rl = 4;
    int kl = 5;
    int ll = 4;
    int el = 3;
    float q = 0.3f;
    String[] cvars = new String[]{"a", "b"};
    String[] vars = new String[]{"w", "x", "y", "z"};
    RelationTable<GenPolynomial<BigRational>> table;
    RecSolvablePolynomialRing<BigRational> ring;
    BigRational cfac;
    GenSolvablePolynomialRing<GenPolynomial<BigRational>> sring;
    GenPolynomialRing<BigRational> cring;
    TermOrder tord = new TermOrder(2);

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)RecSolvablePolynomialTest.suite());
    }

    public RecSolvablePolynomialTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(RecSolvablePolynomialTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.cfac = new BigRational(1L);
        this.cring = new GenPolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        this.ring = new RecSolvablePolynomialRing(this.cring, this.tord, this.vars);
        WeylRelations weylRelations = new WeylRelations();
        this.ring.addRelations(weylRelations);
        this.table = this.ring.table;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.table = null;
        this.ring = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstructor() {
        RecSolvablePolynomialTest.assertFalse((String)"not commutative", (boolean)this.ring.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"associative", (boolean)this.ring.isAssociative());
        this.a = new RecSolvablePolynomial<BigRational>(this.ring);
        RecSolvablePolynomialTest.assertTrue((String)"length( a ) = 0", (this.a.length() == 0 ? 1 : 0) != 0);
        RecSolvablePolynomialTest.assertTrue((String)"isZERO( a )", (boolean)this.a.isZERO());
        RecSolvablePolynomialTest.assertTrue((String)"isONE( a )", (!this.a.isONE() ? 1 : 0) != 0);
        this.c = this.ring.getONE();
        RecSolvablePolynomialTest.assertTrue((String)"length( c ) = 1", (this.c.length() == 1 ? 1 : 0) != 0);
        RecSolvablePolynomialTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        RecSolvablePolynomialTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.ring.getZERO();
        RecSolvablePolynomialTest.assertTrue((String)"length( d ) = 0", (this.d.length() == 0 ? 1 : 0) != 0);
        RecSolvablePolynomialTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        RecSolvablePolynomialTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (GenPolynomial genPolynomial : this.ring.generators()) {
            RecSolvablePolynomialTest.assertFalse((String)"not isZERO( g )", (boolean)genPolynomial.isZERO());
        }
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.ring.random(this.kl * (i + 1), this.ll + 2 * i, this.el + i, this.q);
            RecSolvablePolynomialTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.length() >= 0 ? 1 : 0) != 0);
            RecSolvablePolynomialTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            RecSolvablePolynomialTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
        }
    }

    public void testAddition() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (RecSolvablePolynomial)this.a.subtract((BigRational)((Object)this.a));
        RecSolvablePolynomialTest.assertTrue((String)"a-a = 0", (boolean)this.c.isZERO());
        this.b = (RecSolvablePolynomial)this.a.sum((BigRational)((Object)this.a));
        this.c = (RecSolvablePolynomial)this.b.subtract((BigRational)((Object)this.a));
        RecSolvablePolynomialTest.assertEquals((String)"a+a-a = a", this.c, this.a);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = (RecSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (RecSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        RecSolvablePolynomialTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = (RecSolvablePolynomial)this.a.sum((BigRational)((Object)this.b.sum((BigRational)((Object)this.c))));
        this.e = (RecSolvablePolynomial)this.a.sum((BigRational)((Object)this.b)).sum(this.c);
        RecSolvablePolynomialTest.assertEquals((String)"a+(b+c) = (a+b)+c", this.d, this.e);
        ExpVector expVector = ExpVector.EVRAND(this.rl, this.el, this.q);
        Element element = this.cring.random(this.kl);
        this.b = ((RecSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (RecSolvablePolynomial)this.a.sum((BigRational)((Object)this.b));
        this.d = (RecSolvablePolynomial)this.a.sum((BigRational)element, expVector);
        RecSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (RecSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (RecSolvablePolynomial)this.a.subtract((BigRational)element, expVector);
        RecSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
        this.a = this.ring.getZERO();
        this.b = ((RecSolvablePolynomial)this.ring.getONE()).multiply(element, expVector);
        this.c = (RecSolvablePolynomial)this.b.sum((BigRational)((Object)this.a));
        this.d = (RecSolvablePolynomial)this.a.sum((BigRational)element, expVector);
        RecSolvablePolynomialTest.assertEquals((String)"a+p(x,u) = a+(x,u)", this.c, this.d);
        this.c = (RecSolvablePolynomial)this.a.subtract((BigRational)((Object)this.b));
        this.d = (RecSolvablePolynomial)this.a.subtract((BigRational)element, expVector);
        RecSolvablePolynomialTest.assertEquals((String)"a-p(x,u) = a-(x,u)", this.c, this.d);
    }

    public void testMultiplication() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        RecSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply(this.b.multiply(this.c));
        this.e = this.a.multiply(this.b).multiply(this.c);
        RecSolvablePolynomialTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        BigRational bigRational = ((BigRational)((GenPolynomial)this.a.leadingBaseCoefficient()).leadingBaseCoefficient()).inverse();
        GenPolynomial<BigRational> genPolynomial = new GenPolynomial<BigRational>(this.cring, bigRational);
        this.d = (RecSolvablePolynomial)this.a.multiply((RingElem)genPolynomial);
        RecSolvablePolynomialTest.assertTrue((String)"monic(a) = a*(1/ldcf(ldcf(a)))", (boolean)((BigRational)((GenPolynomial)this.d.leadingBaseCoefficient()).leadingBaseCoefficient()).isONE());
        this.d = (RecSolvablePolynomial)this.a.monic();
        RecSolvablePolynomialTest.assertTrue((String)"a.monic(): ", (((GenPolynomial)this.d.leadingBaseCoefficient()).isONE() || ((GenPolynomial)this.d.leadingBaseCoefficient()).equals(this.a.leadingBaseCoefficient()) ? 1 : 0) != 0);
    }

    public void testCommutative() {
        RecSolvablePolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        this.ring = new RecSolvablePolynomialRing(this.cring, this.ring);
        this.table = this.ring.table;
        RecSolvablePolynomialTest.assertTrue((String)"isCommutative()", (boolean)this.ring.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        RecSolvablePolynomialTest.assertEquals((String)"ba == ab: ", this.c, this.d);
    }

    public void testDistributive() {
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.d = this.a.multiply((RecSolvablePolynomial)this.b.sum((BigRational)((Object)this.c)));
        this.e = (RecSolvablePolynomial)this.a.multiply(this.b).sum((BigRational)((Object)this.a.multiply(this.c)));
        RecSolvablePolynomialTest.assertEquals((String)"a(b+c) = ab+ac", this.d, this.e);
    }

    public void testSolvableCoeffs() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        WeylRelations weylRelations = new WeylRelations();
        genSolvablePolynomialRing.addRelations(weylRelations);
        RecSolvablePolynomialTest.assertTrue((String)"# relations == 1", (genSolvablePolynomialRing.table.size() == 1 ? 1 : 0) != 0);
        RecSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        this.ring = new RecSolvablePolynomialRing(genSolvablePolynomialRing, this.ring);
        WeylRelations weylRelations2 = new WeylRelations();
        this.ring.addRelations(weylRelations2);
        RecSolvablePolynomialTest.assertTrue((String)"# relations == 2", (this.ring.table.size() == 2 ? 1 : 0) != 0);
        RecSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("b x + a");
        this.ring.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), genSolvablePolynomial2);
        this.table = this.ring.table;
        RecSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)this.ring.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)this.ring.isAssociative());
        List list = this.ring.generators();
        for (GenPolynomial genPolynomial2 : list) {
            GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)genPolynomial2;
            this.a = new RecSolvablePolynomial<BigRational>(this.ring, genSolvablePolynomial3);
            for (GenPolynomial genPolynomial3 : list) {
                GenSolvablePolynomial genSolvablePolynomial4 = (GenSolvablePolynomial)genPolynomial3;
                this.b = new RecSolvablePolynomial<BigRational>(this.ring, genSolvablePolynomial4);
                this.c = this.a.multiply(this.b);
                ExpVector expVector = this.a.leadingExpVector().sum(this.b.leadingExpVector());
                RecSolvablePolynomialTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)this.c.leadingExpVector().equals(expVector));
                expVector = ((GenPolynomial)this.a.leadingBaseCoefficient()).leadingExpVector().sum(((GenPolynomial)this.b.leadingBaseCoefficient()).leadingExpVector());
                RecSolvablePolynomialTest.assertTrue((String)"LT(a)*LT(b) == LT(c)", (boolean)((GenPolynomial)this.c.leadingBaseCoefficient()).leadingExpVector().equals(expVector));
            }
        }
        this.a = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.b = this.ring.random(this.kl, this.ll, this.el, this.q);
        this.c = this.b.multiply(this.a);
        this.d = this.a.multiply(this.b);
        RecSolvablePolynomialTest.assertTrue((String)"a*b != b*a", (this.c.equals(this.d) || this.c.leadingExpVector().equals(this.d.leadingExpVector()) ? 1 : 0) != 0);
        RecSolvablePolynomialRing recSolvablePolynomialRing = new RecSolvablePolynomialRing(this.ring.coFac, this.ring);
        recSolvablePolynomialRing.table.addSolvRelations(this.ring.table.relationList());
        recSolvablePolynomialRing.coeffTable.addSolvRelations(this.ring.coeffTable.relationList());
        RecSolvablePolynomialTest.assertEquals((String)"ring.table == ring2.table: ", (Object)this.ring.table, (Object)recSolvablePolynomialRing.table);
        RecSolvablePolynomialTest.assertEquals((String)"ring.coeffTable == ring2.coeffTable: ", this.ring.coeffTable, recSolvablePolynomialRing.coeffTable);
    }

    public void testExtendContractWeyl() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        WeylRelations weylRelations = new WeylRelations();
        genSolvablePolynomialRing.addRelations(weylRelations);
        RecSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("b x + a");
        this.ring.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), genSolvablePolynomial2);
        int n = this.rl;
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = this.ring.extend(n);
        GenSolvablePolynomialRing genSolvablePolynomialRing3 = ((RecSolvablePolynomialRing)genSolvablePolynomialRing2).contract(n);
        RecSolvablePolynomialTest.assertEquals((String)"ring == pfec", this.ring, (Object)genSolvablePolynomialRing3);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)genSolvablePolynomial3.extend(genSolvablePolynomialRing2, 0, 0L);
        Map map = recSolvablePolynomial.contract(genSolvablePolynomialRing3);
        ArrayList arrayList = new ArrayList(map.values());
        GenPolynomial genPolynomial2 = (GenPolynomial)arrayList.get(0);
        RecSolvablePolynomialTest.assertEquals((String)"a == aec", (Object)genSolvablePolynomial3, (Object)genPolynomial2);
    }

    public void testDistRecWeyl() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        WeylRelations weylRelations = new WeylRelations();
        genSolvablePolynomialRing.addRelations(weylRelations);
        RecSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        this.ring = new RecSolvablePolynomialRing(genSolvablePolynomialRing, this.tord, this.vars);
        WeylRelations weylRelations2 = new WeylRelations();
        this.ring.addRelations(weylRelations2);
        RecSolvablePolynomialRing<BigRational> recSolvablePolynomialRing = this.ring;
        GenPolynomialRing genPolynomialRing = recSolvablePolynomialRing.distribute();
        RecSolvablePolynomialRing recSolvablePolynomialRing2 = (RecSolvablePolynomialRing)((GenSolvablePolynomialRing)genPolynomialRing).recursive(this.ring.nvar);
        RecSolvablePolynomialTest.assertEquals((String)"ring == pfdr", this.ring, (Object)recSolvablePolynomialRing2);
        GenSolvablePolynomial genSolvablePolynomial = this.ring.random(this.kl, 2 * this.ll, this.el, 2.0f * this.q);
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)PolyUtil.distribute(genPolynomialRing, genSolvablePolynomial);
        GenSolvablePolynomial genSolvablePolynomial3 = (GenSolvablePolynomial)PolyUtil.recursive(recSolvablePolynomialRing2, genSolvablePolynomial2);
        RecSolvablePolynomialTest.assertEquals((String)"a == adr", (Object)genSolvablePolynomial, (Object)genSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial4 = this.ring.parse("x");
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial5 = this.ring.parse("b x + a");
        this.ring.coeffTable.update(genSolvablePolynomial4.leadingExpVector(), genPolynomial.leadingExpVector(), genSolvablePolynomial5);
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing2 = RecSolvablePolynomialRing.distribute(this.ring);
        RecSolvablePolynomialRing recSolvablePolynomialRing3 = (RecSolvablePolynomialRing)genSolvablePolynomialRing2.recursive(this.ring.nvar);
        RecSolvablePolynomialTest.assertEquals((String)"ring == pfrdr", this.ring, (Object)recSolvablePolynomialRing3);
        genSolvablePolynomial2 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing2, genSolvablePolynomial);
        genSolvablePolynomial3 = (GenSolvablePolynomial)PolyUtil.recursive(recSolvablePolynomialRing3, genSolvablePolynomial2);
        RecSolvablePolynomialTest.assertEquals((String)"a == adr", (Object)genSolvablePolynomial, (Object)genSolvablePolynomial3);
    }

    public void testReverseWeyl() {
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, this.cvars);
        WeylRelations weylRelations = new WeylRelations();
        genSolvablePolynomialRing.addRelations(weylRelations);
        RecSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        GenSolvablePolynomial genSolvablePolynomial = this.ring.parse("x");
        GenPolynomial genPolynomial = genSolvablePolynomialRing.parse("b");
        GenSolvablePolynomial genSolvablePolynomial2 = this.ring.parse("b x + a");
        this.ring.coeffTable.update(genSolvablePolynomial.leadingExpVector(), genPolynomial.leadingExpVector(), genSolvablePolynomial2);
        GenSolvablePolynomialRing genSolvablePolynomialRing2 = this.ring.reverse();
        GenSolvablePolynomialRing genSolvablePolynomialRing3 = ((RecSolvablePolynomialRing)genSolvablePolynomialRing2).reverse();
        RecSolvablePolynomialTest.assertEquals((String)"pf == pfrr", this.ring, (Object)genSolvablePolynomialRing3);
        GenSolvablePolynomial genSolvablePolynomial3 = this.ring.random(this.kl, this.ll, this.el, this.q);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)genSolvablePolynomial3.reverse(genSolvablePolynomialRing2);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)recSolvablePolynomial.reverse(genSolvablePolynomialRing3);
        RecSolvablePolynomialTest.assertEquals((String)"a == arr", (Object)genSolvablePolynomial3, (Object)recSolvablePolynomial2);
    }

    public void testRecursiveWeyl() {
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, stringArray);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>(genSolvablePolynomialRing);
        genSolvablePolynomialRing.addRelations(weylRelations);
        RecSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(2);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(genPolynomial2);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genPolynomial);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genPolynomial2);
        RecSolvablePolynomial recSolvablePolynomial3 = recSolvablePolynomial.multiply(recSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial4 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        RecSolvablePolynomialTest.assertEquals((String)"dr.ring == cr.ring", recSolvablePolynomial4.ring, recSolvablePolynomial3.ring);
        RecSolvablePolynomialTest.assertEquals((String)"dr == cr", (Object)recSolvablePolynomial4, recSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, recSolvablePolynomial3);
        RecSolvablePolynomialTest.assertEquals((String)"dd == cd", (Object)genSolvablePolynomial2, genSolvablePolynomial);
    }

    public void testRecursiveIteratedWeyl() {
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        GenSolvablePolynomialRing<BigRational> genSolvablePolynomialRing = new GenSolvablePolynomialRing<BigRational>(this.cfac, this.tord, stringArray);
        WeylRelationsIterated weylRelationsIterated = new WeylRelationsIterated();
        genSolvablePolynomialRing.addRelations(weylRelationsIterated);
        RecSolvablePolynomialTest.assertFalse((String)"isCommutative()", (boolean)genSolvablePolynomialRing.isCommutative());
        RecSolvablePolynomialTest.assertTrue((String)"isAssociative()", (boolean)genSolvablePolynomialRing.isAssociative());
        GenPolynomialRing genPolynomialRing = genSolvablePolynomialRing.recursive(2);
        GenPolynomial genPolynomial = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial genPolynomial2 = genSolvablePolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenSolvablePolynomial<GenPolynomial> genSolvablePolynomial = ((GenSolvablePolynomial)genPolynomial).multiply(genPolynomial2);
        RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genPolynomial);
        RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genPolynomial2);
        RecSolvablePolynomial recSolvablePolynomial3 = recSolvablePolynomial.multiply(recSolvablePolynomial2);
        RecSolvablePolynomial recSolvablePolynomial4 = (RecSolvablePolynomial)PolyUtil.recursive(genPolynomialRing, genSolvablePolynomial);
        RecSolvablePolynomialTest.assertEquals((String)"dr.ring == cr.ring", recSolvablePolynomial4.ring, recSolvablePolynomial3.ring);
        RecSolvablePolynomialTest.assertEquals((String)"dr == cr", (Object)recSolvablePolynomial4, recSolvablePolynomial3);
        GenSolvablePolynomial genSolvablePolynomial2 = (GenSolvablePolynomial)PolyUtil.distribute(genSolvablePolynomialRing, recSolvablePolynomial3);
        RecSolvablePolynomialTest.assertEquals((String)"dd == cd", (Object)genSolvablePolynomial2, genSolvablePolynomial);
    }
}

