/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocal;
import edu.jas.application.SolvableLocalRing;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SolvableLocalTest
extends TestCase {
    SolvableLocalRing<BigRational> efac;
    GenSolvablePolynomialRing<BigRational> mfac;
    SolvableIdeal<BigRational> id;
    SolvableLocal<BigRational> a;
    SolvableLocal<BigRational> b;
    SolvableLocal<BigRational> c;
    SolvableLocal<BigRational> d;
    SolvableLocal<BigRational> e;
    SolvableLocal<BigRational> az;
    SolvableLocal<BigRational> bz;
    SolvableLocal<BigRational> cz;
    SolvableLocal<BigRational> dz;
    SolvableLocal<BigRational> ez;
    int rl = 4;
    int kl = 3;
    int ll = 3;
    int el = 2;
    float q = 0.2f;
    int il = this.rl == 1 ? 1 : 2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SolvableLocalTest.suite());
    }

    public SolvableLocalTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableLocalTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.mfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.rl, termOrder, stringArray);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.mfac);
        if (!this.mfac.isAssociative()) {
            System.out.println("ring not associative: " + this.mfac);
        }
        this.id = this.genIdealA();
        assert (!this.id.isONE()) : "id = " + this.id;
        this.efac = new SolvableLocalRing<BigRational>(this.id);
    }

    protected SolvableIdeal<BigRational> genRandomIdeal() {
        do {
            ArrayList arrayList = new ArrayList(this.il);
            for (int i = 0; i < this.il; ++i) {
                GenPolynomial genPolynomial = this.mfac.random(this.kl, this.ll, this.el + 1, this.q);
                while (genPolynomial.isConstant()) {
                    genPolynomial = this.mfac.random(this.kl, this.ll, this.el + 1, this.q);
                }
                arrayList.add(genPolynomial);
            }
            SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.mfac, arrayList);
            solvableIdeal.doGB();
        } while (this.id.isONE());
        return this.id;
    }

    protected SolvableIdeal<BigRational> genIdealA() {
        ArrayList arrayList = new ArrayList(this.il);
        GenPolynomial genPolynomial = this.mfac.parse("y^2 - 42/5");
        arrayList.add(genPolynomial);
        genPolynomial = this.mfac.parse("x^2");
        arrayList.add(genPolynomial);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.mfac, arrayList);
        solvableIdeal.doGB();
        return solvableIdeal;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.efac = null;
        ComputerThreads.terminate();
    }

    public void testConstruction() {
        this.c = this.efac.getONE();
        SolvableLocalTest.assertTrue((String)"length( c ) = 1", (this.c.num.length() == 1 ? 1 : 0) != 0);
        SolvableLocalTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        SolvableLocalTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.efac.getZERO();
        SolvableLocalTest.assertTrue((String)"length( d ) = 0", (this.d.num.length() == 0 ? 1 : 0) != 0);
        SolvableLocalTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        SolvableLocalTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (SolvableLocal<BigRational> solvableLocal : this.efac.generators()) {
            SolvableLocalTest.assertFalse((String)"not isZERO( g )", (boolean)solvableLocal.isZERO());
        }
        SolvableLocalTest.assertTrue((String)"isAssociative: ", (boolean)this.efac.isAssociative());
    }

    public void testRandom() {
        for (int i = 0; i < 3; ++i) {
            this.a = this.efac.random(this.kl + i, this.ll + 2, this.el, this.q);
            if (this.a.isZERO() || this.a.isONE()) continue;
            SolvableLocalTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.num.length() >= 0 ? 1 : 0) != 0);
            SolvableLocalTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            SolvableLocalTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            SolvableLocalTest.assertEquals((String)"a == a: ", this.a, this.a);
        }
    }

    public void testAddition() {
        this.a = this.efac.random(this.kl, this.ll, this.el + 1, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el + 1, this.q);
        this.c = this.a.sum((SolvableLocal<BigRational>)this.efac.getZERO());
        this.d = this.a.subtract((SolvableLocal<BigRational>)this.efac.getZERO());
        SolvableLocalTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((SolvableLocal)this.efac.getZERO()).sum(this.a);
        this.d = ((SolvableLocal)this.efac.getZERO()).subtract(this.a.negate());
        SolvableLocalTest.assertEquals((String)"0+a = 0-(-a)", this.c, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        SolvableLocalTest.assertEquals((String)("(a+b)-b == a: " + this.a + ", " + this.b), this.a, this.d);
        this.e = this.d.subtract(this.a);
        SolvableLocalTest.assertTrue((String)"((a+b)-b)-a == 0", (boolean)this.e.isZERO());
        this.c = new SolvableLocal<BigRational>(this.efac, (GenSolvablePolynomial<BigRational>)this.mfac.univariate(1, 2L));
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        SolvableLocalTest.assertEquals((String)"c+(a+b) = (c+a)+b", this.d, this.e);
    }

    public void testMultiplication() {
        this.a = this.efac.random(this.kl, this.ll, this.el + 0, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el + 0, this.q);
        this.c = this.a.multiply((BigRational)this.efac.getONE());
        this.d = ((SolvableLocal)this.efac.getONE()).multiply(this.a);
        SolvableLocalTest.assertEquals((String)"a*1 = 1*a", this.c, this.a);
        SolvableLocalTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.c = new SolvableLocal<BigRational>(this.efac, (GenSolvablePolynomial<BigRational>)this.mfac.univariate(1, 2L));
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        SolvableLocalTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply((BigRational)((Object)this.a));
            SolvableLocalTest.assertTrue((String)"a*1/a = 1", (boolean)this.d.isONE());
        }
    }

    public void testParse() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q * 2.0f);
        PrettyPrint.setPretty();
        String string = this.a.toString();
        this.b = this.efac.parse(string);
        SolvableLocalTest.assertEquals((String)"parse(a.toSting()) = a", this.a, this.b);
    }
}

