/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.vector;

import edu.jas.kern.StringUtil;
import edu.jas.structure.ModulFactory;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.vector.GenVector;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Logger;

public class GenVectorModul<C extends RingElem<C>>
implements ModulFactory<GenVector<C>, C> {
    private static final Logger logger = Logger.getLogger(GenVectorModul.class);
    public final RingFactory<C> coFac;
    public final int cols;
    public final GenVector<C> ZERO;
    public final List<GenVector<C>> BASIS;
    private static final Random random = new Random();
    public static final float DEFAULT_DENSITY = 0.5f;
    private final float density = 0.5f;

    public GenVectorModul(RingFactory<C> ringFactory, int n) {
        this.coFac = ringFactory;
        this.cols = n;
        ArrayList arrayList = new ArrayList(this.cols);
        for (int i = 0; i < this.cols; ++i) {
            arrayList.add(this.coFac.getZERO());
        }
        this.ZERO = new GenVector(this, arrayList);
        this.BASIS = new ArrayList<GenVector<C>>(this.cols);
        List list = this.coFac.generators();
        for (int i = 0; i < this.cols; ++i) {
            for (RingElem ringElem : list) {
                ArrayList<RingElem> arrayList2 = new ArrayList<RingElem>(arrayList);
                arrayList2.set(i, ringElem);
                this.BASIS.add(new GenVector(this, arrayList2));
            }
        }
        logger.info((Object)(this.cols + " module over " + this.coFac + "constructed"));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.coFac.getClass().getSimpleName());
        stringBuffer.append("[" + this.cols + "]");
        return stringBuffer.toString();
    }

    @Override
    public String toScript() {
        StringBuffer stringBuffer = new StringBuffer("Vec(");
        String string = null;
        try {
            string = ((RingElem)((Object)this.coFac)).toScriptFactory();
        }
        catch (Exception exception) {
            string = this.coFac.toScript();
        }
        stringBuffer.append(string + "," + this.cols + " )");
        return stringBuffer.toString();
    }

    @Override
    public GenVector<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public List<GenVector<C>> generators() {
        return this.BASIS;
    }

    @Override
    public boolean isFinite() {
        return this.coFac.isFinite();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GenVectorModul)) {
            return false;
        }
        GenVectorModul genVectorModul = (GenVectorModul)object;
        if (this.cols != genVectorModul.cols) {
            return false;
        }
        return this.coFac.equals(genVectorModul.coFac);
    }

    public int hashCode() {
        int n = this.cols;
        n = 37 * n + this.coFac.hashCode();
        return n;
    }

    @Override
    public GenVector<C> fromInteger(long l) {
        RingElem ringElem = (RingElem)this.coFac.fromInteger(l);
        return this.BASIS.get(0).scalarMultiply(ringElem);
    }

    @Override
    public GenVector<C> fromInteger(BigInteger bigInteger) {
        RingElem ringElem = (RingElem)this.coFac.fromInteger(bigInteger);
        return this.BASIS.get(0).scalarMultiply(ringElem);
    }

    @Override
    public GenVector<C> fromList(List<C> list) {
        if (list == null) {
            return this.ZERO;
        }
        if (list.size() > this.cols) {
            throw new IllegalArgumentException("size v > cols " + list + " > " + this.cols);
        }
        ArrayList arrayList = new ArrayList(this.cols);
        arrayList.addAll(list);
        for (int i = arrayList.size(); i < this.cols; ++i) {
            arrayList.add(this.coFac.getZERO());
        }
        return new GenVector(this, arrayList);
    }

    @Override
    public GenVector<C> random(int n) {
        return this.random(n, 0.5f, random);
    }

    @Override
    public GenVector<C> random(int n, float f) {
        return this.random(n, f, random);
    }

    @Override
    public GenVector<C> random(int n, Random random) {
        return this.random(n, 0.5f, random);
    }

    public GenVector<C> random(int n, float f, Random random) {
        ArrayList arrayList = new ArrayList(this.cols);
        for (int i = 0; i < this.cols; ++i) {
            if (random.nextFloat() < f) {
                arrayList.add(this.coFac.random(n));
                continue;
            }
            arrayList.add(this.coFac.getZERO());
        }
        return new GenVector(this, arrayList);
    }

    @Override
    public GenVector<C> copy(GenVector<C> genVector) {
        if (genVector == null) {
            return genVector;
        }
        return genVector.copy();
    }

    @Override
    public GenVector<C> parse(String string) {
        RingElem ringElem;
        int n = string.indexOf("[");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.indexOf("]")) >= 0) {
            string = string.substring(0, n);
        }
        ArrayList<RingElem> arrayList = new ArrayList<RingElem>(this.cols);
        do {
            if ((n = string.indexOf(",")) < 0) continue;
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            ringElem = (RingElem)this.coFac.parse(string2);
            arrayList.add(ringElem);
        } while (n >= 0);
        if (string.trim().length() > 0) {
            ringElem = (RingElem)this.coFac.parse(string);
            arrayList.add(ringElem);
        }
        return new GenVector(this, arrayList);
    }

    @Override
    public GenVector<C> parse(Reader reader) {
        String string = StringUtil.nextPairedString(reader, '[', ']');
        return this.parse(string);
    }
}

