/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.RealAlgebraicRing;
import edu.jas.application.RootFactory;
import edu.jas.arith.BigDecimal;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.root.ComplexAlgebraicNumber;
import edu.jas.structure.Power;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.io.Serializable;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ComplexRootTest
extends TestCase {
    TermOrder to = new TermOrder(2);
    GenPolynomialRing<Complex<BigRational>> dfac;
    ComplexRing<BigRational> cfac;
    BigRational eps;
    Complex<BigRational> ceps;
    GenPolynomial<Complex<BigRational>> a;
    GenPolynomial<Complex<BigRational>> b;
    GenPolynomial<Complex<BigRational>> c;
    GenPolynomial<Complex<BigRational>> d;
    GenPolynomial<Complex<BigRational>> e;
    int rl = 1;
    int kl = 3;
    int ll = 3;
    int el = 5;
    float q = 0.7f;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ComplexRootTest.suite());
        ComputerThreads.terminate();
    }

    public ComplexRootTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ComplexRootTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.cfac = new ComplexRing<BigRational>(new BigRational(1L));
        String[] stringArray = new String[]{"z"};
        this.dfac = new GenPolynomialRing<BigRational>(this.cfac, this.rl, this.to, stringArray);
        this.eps = Power.positivePower(new BigRational(1L, 10L), BigDecimal.DEFAULT_PRECISION);
        this.ceps = new Complex<BigRational>(this.cfac, this.eps);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.dfac = null;
        this.cfac = null;
        this.eps = null;
    }

    public void testComplexRootsImag() {
        this.a = this.dfac.parse("z^6 - i3");
        List list = RootFactory.complexAlgebraicNumbersComplex(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (Complex complex : list) {
            ComplexRootTest.assertTrue((String)("f(r) == 0: " + complex), (boolean)RootFactory.isRoot(this.a, complex));
        }
    }

    public void testComplexRootsRand() {
        this.a = ((GenPolynomial)this.dfac.random(this.ll + 1)).monic();
        if (this.a.isZERO() || this.a.isONE()) {
            this.a = this.dfac.parse("z^6 - i3");
        }
        SquarefreeAbstract<BigRational> squarefreeAbstract = SquarefreeFactory.getImplementation(this.cfac);
        this.a = squarefreeAbstract.squarefreePart(this.a);
        List list = RootFactory.complexAlgebraicNumbersComplex(this.a);
        ComplexRootTest.assertTrue((String)("#roots == deg(a): " + ((long)list.size() - this.a.degree(0)) + ", a = " + this.a), ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (Complex complex : list) {
            ComplexRootTest.assertTrue((String)("f(r) == 0: " + complex), (boolean)RootFactory.isRoot(this.a, complex));
        }
    }

    public void testPolynomialComplexRoots() {
        Serializable serializable;
        this.a = this.dfac.parse("z^3 - 2");
        List list = RootFactory.complexAlgebraicNumbersComplex(this.a);
        ComplexRootTest.assertTrue((String)"#roots == deg(a) ", ((long)list.size() == this.a.degree(0) ? 1 : 0) != 0);
        for (Complex serializable22 : list) {
            serializable = serializable22.getRe().ring;
            ((RealAlgebraicRing)serializable).setField(true);
            ComplexRootTest.assertTrue((String)"isField(rfac) ", (boolean)((RealAlgebraicRing)serializable).isField());
            ComplexRootTest.assertTrue((String)("f(r) == 0: " + serializable22), (boolean)RootFactory.isRoot(this.a, serializable22));
        }
        Complex complex = list.get(2);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complex.ring, this.to, new String[]{"t"});
        serializable = genPolynomialRing.univariate(0, 2L).subtract(complex.multiply(complex));
        serializable = ((GenPolynomial)serializable).monic();
        SquarefreeAbstract squarefreeAbstract = SquarefreeFactory.getImplementation(complex.ring);
        serializable = squarefreeAbstract.squarefreePart(serializable);
        long l = System.currentTimeMillis();
        List list2 = RootFactory.complexAlgebraicNumbersComplex(serializable);
        l = System.currentTimeMillis() - l;
        ComplexRootTest.assertTrue((String)("nonsense " + l), (l >= 0L ? 1 : 0) != 0);
        for (Complex complex2 : list2) {
            ComplexRootTest.assertTrue((String)("f(r) == 0: " + complex2), (boolean)RootFactory.isRoot(serializable, complex2));
        }
        ComplexRootTest.assertTrue((String)("#croots == deg(cpol) " + list2.size() + " != " + ((GenPolynomial)serializable).degree(0)), ((long)list2.size() == ((GenPolynomial)serializable).degree(0) ? 1 : 0) != 0);
        long l2 = System.currentTimeMillis();
        List list3 = edu.jas.root.RootFactory.complexAlgebraicNumbersComplex(serializable);
        l2 = System.currentTimeMillis() - l2;
        ComplexRootTest.assertTrue((String)("nonsense " + l2), (l2 >= 0L ? 1 : 0) != 0);
        for (ComplexAlgebraicNumber complexAlgebraicNumber : list3) {
            ComplexRootTest.assertTrue((String)("f(r) == 0: " + complexAlgebraicNumber), (boolean)edu.jas.root.RootFactory.isRootComplex(serializable, complexAlgebraicNumber));
        }
        long l3 = System.currentTimeMillis();
        for (Complex complex3 : list2) {
            String string = complex3.getRe().decimalMagnitude() + " + " + complex3.getIm().decimalMagnitude() + " i";
            ComplexRootTest.assertFalse((String)"crs not empty", (string.length() == 0 ? 1 : 0) != 0);
        }
        l3 = System.currentTimeMillis() - l3;
        ComplexRootTest.assertTrue((String)("nonsense " + l3), (l3 >= 0L ? 1 : 0) != 0);
        long l4 = System.currentTimeMillis();
        for (ComplexAlgebraicNumber complexAlgebraicNumber : list3) {
            String string = complexAlgebraicNumber.decimalMagnitude().toString();
            ComplexRootTest.assertFalse((String)"crs not empty", (string.length() == 0 ? 1 : 0) != 0);
        }
        l4 = System.currentTimeMillis() - l4;
        ComplexRootTest.assertTrue((String)("nonsense " + l4), (l4 >= 0L ? 1 : 0) != 0);
        ComplexRootTest.assertTrue((String)"#coroots == deg(cpol) ", ((long)list3.size() == ((GenPolynomial)serializable).degree(0) ? 1 : 0) != 0);
    }
}

