/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.ChannelFactory;
import edu.jas.util.Executable;
import edu.jas.util.ExecutableServer;
import edu.jas.util.SocketChannel;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class ExecutableServerTest
extends TestCase {
    private static final String host = "localhost";
    private static final int port = 4711;
    private ExecutableServer es;
    private ChannelFactory cf;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)ExecutableServerTest.suite());
    }

    public ExecutableServerTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ExecutableServerTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.es = new ExecutableServer(4711);
        this.es.init();
        this.cf = new ChannelFactory();
    }

    protected void tearDown() {
        this.es.terminate();
        this.es = null;
        this.cf.terminate();
        this.cf = null;
    }

    public void testExecutableServer1() {
        ExecutableServerTest.assertTrue((String)"should never fail", (boolean)true);
    }

    public void testExecutableServer2() {
        Executable executable = new Executable("2");
        try {
            SocketChannel socketChannel = this.cf.getChannel(host, 4711);
            socketChannel.send(executable);
            Object object = socketChannel.receive();
            ExecutableServerTest.assertTrue((String)"o:String", (boolean)(object instanceof String));
            ExecutableServerTest.assertEquals((String)"o==done", (String)((String)object), (String)"Done");
            socketChannel.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ExecutableServerTest.fail((String)"IOException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            ExecutableServerTest.fail((String)"ClassNotFoundException");
        }
    }

    public void testExecutableServer3() {
        Executable executable = new Executable("3");
        int n = 1;
        try {
            SocketChannel socketChannel = this.cf.getChannel(host, 4711);
            for (int i = 0; i < n; ++i) {
                socketChannel.send(executable);
                Object object = socketChannel.receive();
                ExecutableServerTest.assertTrue((String)"o:String", (boolean)(object instanceof String));
                ExecutableServerTest.assertEquals((String)"o==done", (String)((String)object), (String)"Done");
            }
            socketChannel.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ExecutableServerTest.fail((String)"IOException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            ExecutableServerTest.fail((String)"ClassNotFoundException");
        }
    }

    public void testExecutableServer4() {
        Executable executable = null;
        SocketChannel socketChannel = null;
        try {
            for (int i = 0; i < 4; ++i) {
                executable = new Executable("4-" + i);
                socketChannel = this.cf.getChannel(host, 4711);
                socketChannel.send(executable);
                Object object = socketChannel.receive();
                ExecutableServerTest.assertTrue((String)"o:String", (boolean)(object instanceof String));
                ExecutableServerTest.assertEquals((String)"o==done", (String)((String)object), (String)"Done");
                executable = null;
                socketChannel.close();
                socketChannel = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ExecutableServerTest.fail((String)"IOException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            ExecutableServerTest.fail((String)"ClassNotFoundException");
        }
    }
}

