/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.CriticalPairList;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.MiReducerSeqPair;
import edu.jas.gb.ReducerSeqPair;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.Terminator;
import edu.jas.util.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class GroebnerBaseSeqPairParallel<C extends RingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = Logger.getLogger(GroebnerBaseSeqPairParallel.class);
    protected final int threads;
    protected final transient ThreadPool pool;

    public GroebnerBaseSeqPairParallel() {
        this(2);
    }

    public GroebnerBaseSeqPairParallel(int n) {
        this(n, new ThreadPool(n));
    }

    public GroebnerBaseSeqPairParallel(int n, ThreadPool threadPool) {
        this(n, threadPool, new ReductionPar());
    }

    public GroebnerBaseSeqPairParallel(int n, Reduction<C> reduction) {
        this(n, new ThreadPool(n), reduction);
    }

    public GroebnerBaseSeqPairParallel(int n, ThreadPool threadPool, Reduction<C> reduction) {
        super(reduction);
        if (!(reduction instanceof ReductionPar)) {
            logger.warn((Object)"parallel GB should use parallel aware reduction");
        }
        if (n < 1) {
            n = 1;
        }
        this.threads = n;
        this.pool = threadPool;
    }

    @Override
    public void terminate() {
        if (this.pool == null) {
            return;
        }
        this.pool.terminate();
    }

    @Override
    public int cancel() {
        if (this.pool == null) {
            return 0;
        }
        int n = this.pool.cancel();
        return n;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        List<GenPolynomial<C>> list2 = new ArrayList<GenPolynomial<C>>();
        CriticalPairList<C> criticalPairList = null;
        int n2 = list.size();
        ListIterator<GenPolynomial<C>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            GenPolynomial<C> genPolynomial = listIterator.next();
            if (genPolynomial.length() > 0) {
                if ((genPolynomial = genPolynomial.monic()).isONE()) {
                    list2.clear();
                    list2.add(genPolynomial);
                    return list2;
                }
                list2.add(genPolynomial);
                if (criticalPairList == null) {
                    criticalPairList = new CriticalPairList<C>(n, genPolynomial.ring);
                    if (!genPolynomial.ring.coFac.isField()) {
                        throw new IllegalArgumentException("coefficients not from a field");
                    }
                }
                criticalPairList.put(genPolynomial);
                continue;
            }
            --n2;
        }
        if (n2 <= 1) {
            return list2;
        }
        Terminator terminator = new Terminator(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            ReducerSeqPair<C> reducerSeqPair = new ReducerSeqPair<C>(terminator, list2, criticalPairList);
            this.pool.addJob(reducerSeqPair);
        }
        terminator.waitDone();
        if (Thread.currentThread().isInterrupted()) {
            throw new RuntimeException("interrupt before minimalGB");
        }
        logger.debug((Object)("#parallel list = " + list2.size()));
        list2 = this.minimalGB(list2);
        logger.info((Object)("" + criticalPairList));
        return list2;
    }

    @Override
    public List<GenPolynomial<C>> minimalGB(List<GenPolynomial<C>> list) {
        GenPolynomial<C> genPolynomial;
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        ListIterator<GenPolynomial<Object>> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            genPolynomial = listIterator.next();
            if (genPolynomial.length() == 0) continue;
            arrayList.add(genPolynomial);
        }
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(arrayList.size());
        while (arrayList.size() > 0) {
            ExpVector expVector;
            GenPolynomial<Object> genPolynomial2;
            genPolynomial = arrayList.remove(0);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            listIterator = arrayList.listIterator();
            boolean bl = false;
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            listIterator = arrayList2.listIterator();
            while (listIterator.hasNext() && !bl) {
                genPolynomial2 = listIterator.next();
                expVector = genPolynomial2.leadingExpVector();
                bl = expVector2.multipleOf(expVector);
            }
            if (bl) continue;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        if (arrayList.size() <= 1) {
            return arrayList;
        }
        Collections.reverse(arrayList);
        MiReducerSeqPair[] miReducerSeqPairArray = new MiReducerSeqPair[arrayList.size()];
        int n = 0;
        arrayList2 = new ArrayList(arrayList.size());
        while (arrayList.size() > 0) {
            genPolynomial = arrayList.remove(0);
            ArrayList arrayList3 = new ArrayList(arrayList.size() + arrayList2.size());
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            miReducerSeqPairArray[n] = new MiReducerSeqPair(arrayList3, genPolynomial);
            this.pool.addJob(miReducerSeqPairArray[n]);
            ++n;
            arrayList2.add(genPolynomial);
        }
        arrayList = arrayList2;
        arrayList2 = new ArrayList(arrayList.size());
        for (n = 0; n < miReducerSeqPairArray.length; ++n) {
            genPolynomial = miReducerSeqPairArray[n].getNF();
            arrayList2.add(genPolynomial);
        }
        return arrayList2;
    }
}

