/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gbufd;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.gbufd.PseudoReduction;
import edu.jas.gbufd.PseudoReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class GroebnerBasePseudoRecSeq<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<GenPolynomial<C>> {
    private static final Logger logger = Logger.getLogger(GroebnerBasePseudoRecSeq.class);
    private final boolean debug = logger.isDebugEnabled();
    protected final GreatestCommonDivisorAbstract<C> engine;
    protected final PseudoReduction<C> redRec;
    protected final PseudoReduction<GenPolynomial<C>> red;
    protected final RingFactory<GenPolynomial<C>> cofac;
    protected final RingFactory<C> baseCofac;

    public GroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory) {
        this(new PseudoReductionSeq<GenPolynomial<C>>(), ringFactory, new OrderedPairlist<GenPolynomial<C>>(new GenPolynomialRing<GenPolynomial<C>>(ringFactory, 1)));
    }

    public GroebnerBasePseudoRecSeq(RingFactory<GenPolynomial<C>> ringFactory, PairList<GenPolynomial<C>> pairList) {
        this(new PseudoReductionSeq<GenPolynomial<C>>(), ringFactory, pairList);
    }

    public GroebnerBasePseudoRecSeq(PseudoReduction<GenPolynomial<C>> pseudoReduction, RingFactory<GenPolynomial<C>> ringFactory, PairList<GenPolynomial<C>> pairList) {
        super(pseudoReduction, pairList);
        this.red = pseudoReduction;
        this.redRec = pseudoReduction;
        this.cofac = ringFactory;
        GenPolynomialRing genPolynomialRing = (GenPolynomialRing)this.cofac;
        this.baseCofac = genPolynomialRing.coFac;
        this.engine = GCDFactory.getProxy(this.baseCofac);
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> GB(int n, List<GenPolynomial<GenPolynomial<C>>> list) {
        List<GenPolynomial<GenPolynomial<C>>> list2 = this.normalizeZerosOnes(list);
        if ((list2 = this.engine.recursivePrimitivePart(list2)).size() <= 1) {
            return list2;
        }
        GenPolynomialRing genPolynomialRing = list2.get((int)0).ring;
        if (genPolynomialRing.coFac.isField()) {
            throw new IllegalArgumentException("coefficients from a field");
        }
        PairList<GenPolynomial<C>> pairList = this.strategy.create(n, genPolynomialRing);
        pairList.put(list2);
        while (pairList.hasNext()) {
            AbelianGroupElem<GenPolynomial<C>> abelianGroupElem;
            GenPolynomial genPolynomial;
            Pair pair = pairList.removeNext();
            if (pair == null) continue;
            GenPolynomial genPolynomial2 = pair.pi;
            GenPolynomial genPolynomial3 = pair.pj;
            if (this.debug) {
                logger.debug((Object)("pi    = " + genPolynomial2));
                logger.debug((Object)("pj    = " + genPolynomial3));
            }
            if ((genPolynomial = this.red.SPolynomial(genPolynomial2, genPolynomial3)).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.info((Object)("ht(S) = " + genPolynomial.leadingExpVector()));
            }
            if (((GenPolynomial)(abelianGroupElem = this.redRec.normalformRecursive(list2, genPolynomial))).isZERO()) {
                pair.setZero();
                continue;
            }
            if (this.debug) {
                logger.info((Object)("ht(H) = " + ((GenPolynomial)abelianGroupElem).leadingExpVector()));
            }
            abelianGroupElem = this.engine.recursivePrimitivePart((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
            if (((GenPolynomial)(abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs())).isConstant()) {
                list2.clear();
                list2.add((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
                return list2;
            }
            if (this.debug) {
                logger.debug((Object)("H = " + abelianGroupElem));
            }
            if (((GenPolynomial)abelianGroupElem).length() <= 0) continue;
            list2.add((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
            pairList.put((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
        }
        logger.debug((Object)("#sequential list = " + list2.size()));
        list2 = this.minimalGB(list2);
        logger.info((Object)("" + pairList));
        return list2;
    }

    @Override
    public List<GenPolynomial<GenPolynomial<C>>> minimalGB(List<GenPolynomial<GenPolynomial<C>>> list) {
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem;
        List<GenPolynomial<GenPolynomial<C>>> list2 = this.normalizeZerosOnes(list);
        if (list2.size() <= 1) {
            return list2;
        }
        ArrayList arrayList = new ArrayList(list2.size());
        while (list2.size() > 0) {
            abelianGroupElem = list2.remove(0);
            if (this.red.isTopReducible((List<GenPolynomial<GenPolynomial<GenPolynomial<C>>>>)list2, (GenPolynomial<GenPolynomial<GenPolynomial<C>>>)abelianGroupElem) || this.red.isTopReducible(arrayList, (GenPolynomial<GenPolynomial<GenPolynomial<C>>>)abelianGroupElem)) {
                if (!this.debug) continue;
                System.out.println("dropped " + abelianGroupElem);
                ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList2 = new ArrayList<GenPolynomial<GenPolynomial<C>>>(list2);
                arrayList2.addAll(arrayList);
                if (((GenPolynomial)(abelianGroupElem = this.redRec.normalformRecursive((List<GenPolynomial<GenPolynomial<C>>>)arrayList2, (GenPolynomial<GenPolynomial<C>>)abelianGroupElem))).isZERO()) continue;
                System.out.println("error, nf(a) " + abelianGroupElem);
                continue;
            }
            arrayList.add(abelianGroupElem);
        }
        list2 = arrayList;
        if (list2.size() <= 1) {
            return list2;
        }
        Collections.reverse(list2);
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            abelianGroupElem = list2.remove(0);
            abelianGroupElem = this.redRec.normalformRecursive(list2, (GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
            abelianGroupElem = this.engine.recursivePrimitivePart((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
            abelianGroupElem = ((GenPolynomial)abelianGroupElem).abs();
            list2.add((GenPolynomial<GenPolynomial<C>>)abelianGroupElem);
        }
        return list2;
    }

    @Override
    public boolean isGBsimple(int n, List<GenPolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<GenPolynomial<C>> genPolynomial = list.get(i);
            ExpVector expVector = genPolynomial.leadingExpVector();
            for (int j = i + 1; j < list.size(); ++j) {
                GenPolynomial<GenPolynomial<C>> genPolynomial2;
                GenPolynomial<GenPolynomial<C>> genPolynomial3;
                ExpVector expVector2;
                GenPolynomial<GenPolynomial<C>> genPolynomial4 = list.get(j);
                ExpVector expVector3 = genPolynomial4.leadingExpVector();
                if (!this.red.moduleCriterion(n, expVector, expVector3) || !this.red.criterion4(expVector, expVector3, expVector2 = expVector.lcm(expVector3)) || (genPolynomial3 = this.red.SPolynomial(genPolynomial, genPolynomial4)).isZERO() || (genPolynomial2 = this.redRec.normalformRecursive(list, genPolynomial3)).isZERO()) continue;
                logger.info((Object)("no GB: pi = " + genPolynomial + ", pj = " + genPolynomial4));
                logger.info((Object)("s  = " + genPolynomial3 + ", h = " + genPolynomial2));
                return false;
            }
        }
        return true;
    }
}

