/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GBTransportMess;
import edu.jas.gb.GBTransportMessEnd;
import edu.jas.gb.GBTransportMessPairIndex;
import edu.jas.gb.GBTransportMessReq;
import edu.jas.gb.GroebnerBaseDistributedHybrid;
import edu.jas.gb.HybridReducerReceiver;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.RingElem;
import edu.jas.util.ChannelFactory;
import edu.jas.util.DistHashTable;
import edu.jas.util.SocketChannel;
import edu.jas.util.TaggedSocketChannel;
import edu.jas.util.Terminator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

class HybridReducerServer<C extends RingElem<C>>
implements Runnable {
    public static final Logger logger = Logger.getLogger(HybridReducerServer.class);
    public final boolean debug = logger.isDebugEnabled();
    private final Terminator finner;
    private final ChannelFactory cf;
    private TaggedSocketChannel pairChannel;
    private final DistHashTable<Integer, GenPolynomial<C>> theList;
    private final PairList<C> pairlist;
    private final int threadsPerNode;
    public final Integer pairTag = GroebnerBaseDistributedHybrid.pairTag;
    public final Integer resultTag = GroebnerBaseDistributedHybrid.resultTag;
    public final Integer ackTag = GroebnerBaseDistributedHybrid.ackTag;

    HybridReducerServer(int n, Terminator terminator, ChannelFactory channelFactory, DistHashTable<Integer, GenPolynomial<C>> distHashTable, PairList<C> pairList) {
        this.threadsPerNode = n;
        this.finner = terminator;
        this.cf = channelFactory;
        this.theList = distHashTable;
        this.pairlist = pairList;
    }

    @Override
    public void run() {
        HybridReducerReceiver<C> hybridReducerReceiver;
        AtomicInteger atomicInteger;
        SocketChannel socketChannel;
        block22: {
            logger.info((Object)("reducer server running with " + this.cf));
            socketChannel = null;
            try {
                socketChannel = this.cf.getChannel();
                this.pairChannel = new TaggedSocketChannel(socketChannel);
                this.pairChannel.init();
            }
            catch (InterruptedException interruptedException) {
                logger.debug((Object)"get pair channel interrupted");
                interruptedException.printStackTrace();
                return;
            }
            if (this.debug) {
                logger.info((Object)("pairChannel   = " + this.pairChannel));
            }
            this.finner.initIdle(this.threadsPerNode);
            atomicInteger = new AtomicInteger(0);
            hybridReducerReceiver = new HybridReducerReceiver<C>(this.threadsPerNode, this.finner, atomicInteger, this.pairChannel, this.theList, this.pairlist);
            hybridReducerReceiver.start();
            boolean bl = true;
            int n = 0;
            int n2 = 0;
            while (bl) {
                logger.debug((Object)"receive request");
                Object object = null;
                try {
                    object = this.pairChannel.receive(this.pairTag);
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                    interruptedException.printStackTrace();
                }
                catch (IOException iOException) {
                    bl = false;
                    iOException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = false;
                    classNotFoundException.printStackTrace();
                }
                logger.info((Object)("received request, req = " + object));
                if (object == null) {
                    bl = false;
                    break;
                }
                if (!(object instanceof GBTransportMessReq)) {
                    bl = false;
                    break;
                }
                logger.info((Object)"find pair");
                while (!this.pairlist.hasNext()) {
                    if (!this.finner.hasJobs() && !this.pairlist.hasNext()) {
                        bl = false;
                        break;
                    }
                    try {
                        if (++n2 % 3 == 0) {
                            logger.info((Object)("waiting for reducers, remaining = " + this.finner.getJobs()));
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = false;
                        break;
                    }
                }
                if (!this.pairlist.hasNext() && !this.finner.hasJobs()) {
                    logger.info((Object)"termination detection: no pairs and no jobs left");
                    bl = false;
                    break;
                }
                this.finner.notIdle();
                Pair<C> pair = this.pairlist.removeNext();
                if (this.debug) {
                    logger.info((Object)("active count = " + atomicInteger.get()));
                    logger.info((Object)("send pair = " + pair));
                }
                GBTransportMess gBTransportMess = null;
                gBTransportMess = pair != null ? new GBTransportMessPairIndex(pair) : new GBTransportMess();
                try {
                    ++n;
                    this.pairChannel.send(this.pairTag, gBTransportMess);
                    int n3 = atomicInteger.getAndIncrement();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    bl = false;
                    break;
                }
            }
            logger.info((Object)("terminated, send " + n + " reduction pairs"));
            logger.debug((Object)"send end");
            try {
                for (int i = 0; i < this.threadsPerNode; ++i) {
                    this.pairChannel.send(this.pairTag, new GBTransportMessEnd());
                }
            }
            catch (IOException iOException) {
                if (!logger.isDebugEnabled()) break block22;
                iOException.printStackTrace();
            }
        }
        hybridReducerReceiver.terminate();
        int n = atomicInteger.get();
        logger.info((Object)("remaining active tasks = " + n));
        this.pairChannel.close();
        logger.info((Object)"redServ pairChannel.close()");
        this.finner.release();
        socketChannel.close();
        logger.info((Object)"redServ channel.close()");
    }
}

