/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.SolvableIdeal;
import edu.jas.application.SolvableLocalResidue;
import edu.jas.application.SolvableLocalResidueRing;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.TermOrder;
import edu.jas.poly.WeylRelations;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.BasicConfigurator;

public class SolvableLocalResidueTest
extends TestCase {
    SolvableLocalResidueRing<BigRational> efac;
    GenSolvablePolynomialRing<BigRational> mfac;
    SolvableIdeal<BigRational> id;
    SolvableLocalResidue<BigRational> a;
    SolvableLocalResidue<BigRational> b;
    SolvableLocalResidue<BigRational> c;
    SolvableLocalResidue<BigRational> d;
    SolvableLocalResidue<BigRational> e;
    SolvableLocalResidue<BigRational> az;
    SolvableLocalResidue<BigRational> bz;
    SolvableLocalResidue<BigRational> cz;
    SolvableLocalResidue<BigRational> dz;
    SolvableLocalResidue<BigRational> ez;
    int rl = 4;
    int kl = 2;
    int ll = 3;
    int el = 2;
    float q = 0.15f;
    int il = this.rl == 1 ? 1 : 2;

    public static void main(String[] stringArray) {
        BasicConfigurator.configure();
        TestRunner.run((Test)SolvableLocalResidueTest.suite());
    }

    public SolvableLocalResidueTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(SolvableLocalResidueTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        TermOrder termOrder = new TermOrder(2);
        String[] stringArray = new String[]{"w", "x", "y", "z"};
        this.mfac = new GenSolvablePolynomialRing<BigRational>(new BigRational(1L), this.rl, termOrder, stringArray);
        WeylRelations<BigRational> weylRelations = new WeylRelations<BigRational>();
        weylRelations.generate(this.mfac);
        if (!this.mfac.isAssociative()) {
            System.out.println("ring not associative: " + this.mfac);
        }
        this.id = this.genPrimeIdealA();
        assert (!this.id.isONE()) : "id = " + this.id;
        this.efac = new SolvableLocalResidueRing<BigRational>(this.id);
    }

    protected SolvableIdeal<BigRational> genRandomIdeal() {
        do {
            ArrayList arrayList = new ArrayList(this.il);
            for (int i = 0; i < this.il; ++i) {
                GenPolynomial genPolynomial = this.mfac.random(this.kl, this.ll, this.el + 1, this.q);
                while (genPolynomial.isConstant()) {
                    genPolynomial = this.mfac.random(this.kl, this.ll, this.el + 1, this.q);
                }
                arrayList.add(genPolynomial);
            }
            SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.mfac, arrayList);
            solvableIdeal.doGB();
        } while (this.id.isONE());
        return this.id;
    }

    protected SolvableIdeal<BigRational> genIdealA() {
        ArrayList arrayList = new ArrayList(this.il);
        GenPolynomial genPolynomial = this.mfac.parse("y^2 - 42/5");
        arrayList.add(genPolynomial);
        genPolynomial = this.mfac.parse("x^2");
        arrayList.add(genPolynomial);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.mfac, arrayList);
        solvableIdeal.doGB();
        return solvableIdeal;
    }

    protected SolvableIdeal<BigRational> genPrimeIdealA() {
        ArrayList arrayList = new ArrayList(this.il);
        GenPolynomial genPolynomial = this.mfac.parse("y^2 + 5");
        arrayList.add(genPolynomial);
        genPolynomial = this.mfac.parse("x^2 + 3");
        arrayList.add(genPolynomial);
        SolvableIdeal<BigRational> solvableIdeal = new SolvableIdeal<BigRational>(this.mfac, arrayList);
        solvableIdeal.doGB();
        return solvableIdeal;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.efac = null;
        ComputerThreads.terminate();
    }

    public void testConstruction() {
        this.c = this.efac.getONE();
        SolvableLocalResidueTest.assertTrue((String)"length( c ) = 1", (this.c.num.length() == 1 ? 1 : 0) != 0);
        SolvableLocalResidueTest.assertTrue((String)"isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        SolvableLocalResidueTest.assertTrue((String)"isONE( c )", (boolean)this.c.isONE());
        this.d = this.efac.getZERO();
        SolvableLocalResidueTest.assertTrue((String)"length( d ) = 0", (this.d.num.length() == 0 ? 1 : 0) != 0);
        SolvableLocalResidueTest.assertTrue((String)"isZERO( d )", (boolean)this.d.isZERO());
        SolvableLocalResidueTest.assertTrue((String)"isONE( d )", (!this.d.isONE() ? 1 : 0) != 0);
        for (SolvableLocalResidue<BigRational> solvableLocalResidue : this.efac.generators()) {
            SolvableLocalResidueTest.assertFalse((String)"not isZERO( g )", (boolean)solvableLocalResidue.isZERO());
        }
        SolvableLocalResidueTest.assertTrue((String)"isAssociative: ", (boolean)this.efac.isAssociative());
    }

    public void testRandom() {
        for (int i = 0; i < 4; ++i) {
            this.a = this.efac.random(this.kl + i, this.ll + 1, this.el, this.q);
            if (this.a.isZERO() || this.a.isONE()) continue;
            SolvableLocalResidueTest.assertTrue((String)("length( a" + i + " ) <> 0"), (this.a.num.length() >= 0 ? 1 : 0) != 0);
            SolvableLocalResidueTest.assertTrue((String)(" not isZERO( a" + i + " )"), (!this.a.isZERO() ? 1 : 0) != 0);
            SolvableLocalResidueTest.assertTrue((String)(" not isONE( a" + i + " )"), (!this.a.isONE() ? 1 : 0) != 0);
            SolvableLocalResidueTest.assertEquals((String)"a == a: ", this.a, this.a);
        }
    }

    public void testAddition() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.sum((SolvableLocalResidue<BigRational>)this.efac.getZERO());
        this.d = this.a.subtract((SolvableLocalResidue<BigRational>)this.efac.getZERO());
        SolvableLocalResidueTest.assertEquals((String)"a+0 = a-0", this.c, this.d);
        this.c = ((SolvableLocalResidue)this.efac.getZERO()).sum(this.a);
        this.d = ((SolvableLocalResidue)this.efac.getZERO()).subtract(this.a.negate());
        SolvableLocalResidueTest.assertEquals((String)"0+a = 0-(-a)", this.c, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.b.sum(this.a);
        SolvableLocalResidueTest.assertEquals((String)"a+b = b+a", this.c, this.d);
        this.c = this.a.sum(this.b);
        this.d = this.c.subtract(this.b);
        SolvableLocalResidueTest.assertEquals((String)("(a+b)-b = a: b = " + this.b), this.a, this.d);
        this.c = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.c.sum(this.a.sum(this.b));
        this.e = this.c.sum(this.a).sum(this.b);
        SolvableLocalResidueTest.assertEquals((String)("c+(a+b) = (c+a)+b: a = " + this.a + ", b = " + this.b + ", c = " + this.c), this.d, this.e);
    }

    public void testMultiplication() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.efac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a.multiply((BigRational)this.efac.getONE());
        this.d = ((SolvableLocalResidue)this.efac.getONE()).multiply(this.a);
        SolvableLocalResidueTest.assertEquals((String)"a*1 = 1*a", this.c, this.a);
        SolvableLocalResidueTest.assertEquals((String)"a*1 = 1*a", this.c, this.d);
        this.c = this.b.multiply((BigRational)((Object)this.a));
        this.d = this.a.multiply((BigRational)((Object)this.b));
        this.c = new SolvableLocalResidue<BigRational>(this.efac, (GenSolvablePolynomial<BigRational>)this.mfac.univariate(1, 2L));
        this.d = this.a.multiply((BigRational)((Object)this.b.multiply((BigRational)((Object)this.c))));
        this.e = this.a.multiply((BigRational)((Object)this.b)).multiply(this.c);
        SolvableLocalResidueTest.assertEquals((String)"a(bc) = (ab)c", this.d, this.e);
    }

    public void testInverse() {
        this.a = this.efac.random(this.kl, this.ll + 1, this.el + 1, this.q * 1.15f);
        this.b = new SolvableLocalResidue<BigRational>(this.efac, (GenSolvablePolynomial<BigRational>)this.mfac.getONE(), (GenSolvablePolynomial<BigRational>)this.mfac.univariate(1, 2L));
        this.a = this.a.multiply((BigRational)((Object)this.b));
        if (this.a.isUnit()) {
            this.c = this.a.inverse();
            this.d = this.c.multiply((BigRational)((Object)this.a));
            SolvableLocalResidueTest.assertTrue((String)"1/a * a = 1", (boolean)this.d.isONE());
            this.d = this.c.inverse();
            SolvableLocalResidueTest.assertEquals((String)"1/(1/a) = a", this.a, this.d);
        }
    }

    public void testRoot() {
        this.c = this.efac.parse("y");
        this.d = this.efac.parse("5");
        this.e = this.c.multiply((BigRational)((Object)this.c)).sum((SolvableLocalResidue<SolvableLocalResidue<BigRational>>)this.d);
        SolvableLocalResidueTest.assertTrue((String)"e == 0 mod ideal", (boolean)this.e.isZERO());
        for (GenSolvablePolynomial genSolvablePolynomial : this.efac.ideal.getList()) {
            String string = genSolvablePolynomial.toString();
            this.e = this.efac.parse(string);
            SolvableLocalResidueTest.assertTrue((String)"e == 0 mod ideal", (boolean)this.e.isZERO());
        }
    }

    public void testParse() {
        this.a = this.efac.random(this.kl, this.ll, this.el, this.q);
        PrettyPrint.setPretty();
        String string = this.a.toString();
        this.b = this.efac.parse(string);
        SolvableLocalResidueTest.assertEquals((String)"parse(a.toSting()) = a", this.a, this.b);
    }
}

