/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.Ideal;
import edu.jas.application.IdealWithRealAlgebraicRoots;
import edu.jas.application.IdealWithUniv;
import edu.jas.application.PolyUtilApp;
import edu.jas.application.RealAlgebraicNumber;
import edu.jas.application.RealAlgebraicRing;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.TermOrder;
import edu.jas.root.Interval;
import edu.jas.root.RealRootTuple;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class RootFactory {
    private static final Logger logger = Logger.getLogger(RootFactory.class);
    private static boolean debug = logger.isDebugEnabled();

    public static <C extends GcdRingElem<C> & Rational> boolean isRootRealCoeff(GenPolynomial<C> genPolynomial, Complex<RealAlgebraicNumber<C>> complex) {
        RingFactory ringFactory = genPolynomial.ring.coFac;
        ComplexRing complexRing = new ComplexRing(ringFactory);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complexRing, genPolynomial.ring);
        GenPolynomial genPolynomial2 = PolyUtil.complexFromAny(genPolynomialRing, genPolynomial);
        return RootFactory.isRoot(genPolynomial2, complex);
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<Complex<C>> genPolynomial, Complex<RealAlgebraicNumber<C>> complex) {
        GenPolynomialRing genPolynomialRing;
        GenPolynomial genPolynomial2;
        ElemFactory elemFactory = complex.factory();
        Complex<RealAlgebraicNumber<C>> complex2 = PolyUtil.evaluateMain(elemFactory, genPolynomial2 = PolyUtilApp.convertToComplexRealCoefficients(genPolynomialRing = new GenPolynomialRing(elemFactory, (GenPolynomialRing)genPolynomial.factory()), genPolynomial), complex);
        boolean bl = complex2.isZERO();
        if (!bl) {
            logger.info((Object)("f(r) = " + complex2 + ", f = " + genPolynomial + ", r  = " + complex));
            return bl;
        }
        RealAlgebraicRing realAlgebraicRing = (RealAlgebraicRing)((ComplexRing)elemFactory).ring;
        RealRootTuple realRootTuple = realAlgebraicRing.getRoot();
        List list = realRootTuple.tuple;
        Interval interval = list.get((int)0).ring.getRoot();
        Interval interval2 = list.get((int)1).ring.getRoot();
        ComplexRing complexRing = new ComplexRing((RingFactory)((GcdRingElem)interval.left).factory());
        Complex complex3 = new Complex(complexRing, interval.left, interval2.left);
        Complex complex4 = new Complex(complexRing, interval.right, interval2.right);
        Complex complex5 = PolyUtil.evaluateMain(complexRing, genPolynomial, complex3);
        Complex complex6 = PolyUtil.evaluateMain(complexRing, genPolynomial, complex4);
        int n = ((GcdRingElem)complex5.getRe()).signum() * ((GcdRingElem)complex6.getRe()).signum();
        int n2 = ((GcdRingElem)complex5.getIm()).signum() * ((GcdRingElem)complex6.getIm()).signum();
        bl = n <= 0 && n2 <= 0;
        return true;
    }

    public static <C extends GcdRingElem<C> & Rational> boolean isRoot(GenPolynomial<Complex<C>> genPolynomial, List<Complex<RealAlgebraicNumber<C>>> list) {
        for (Complex<RealAlgebraicNumber<C>> complex : list) {
            boolean bl = RootFactory.isRoot(genPolynomial, complex);
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static <C extends GcdRingElem<C> & Rational> List<Complex<RealAlgebraicNumber<C>>> complexAlgebraicNumbersComplex(GenPolynomial<Complex<C>> genPolynomial) {
        ElemFactory elemFactory = genPolynomial.factory();
        if (((GenPolynomialRing)elemFactory).nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing complexRing = (ComplexRing)((GenPolynomialRing)elemFactory).coFac;
        SquarefreeAbstract<GenPolynomial<Complex<C>>> squarefreeAbstract = SquarefreeFactory.getImplementation(complexRing);
        SortedMap<GenPolynomial<Complex<C>>, Long> sortedMap = squarefreeAbstract.squarefreeFactors(genPolynomial.monic());
        Set set = sortedMap.keySet();
        ArrayList<Complex<RealAlgebraicNumber<C>>> arrayList = new ArrayList<Complex<RealAlgebraicNumber<C>>>();
        for (GenPolynomial genPolynomial2 : set) {
            if (genPolynomial2.isConstant() || genPolynomial2.isZERO()) continue;
            List<Complex<RealAlgebraicNumber<C>>> list = RootFactory.complexAlgebraicNumbersSquarefree(genPolynomial2);
            long l = (Long)sortedMap.get(genPolynomial2);
            for (long i = 0L; i < l; ++i) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public static <C extends GcdRingElem<C> & Rational> List<Complex<RealAlgebraicNumber<C>>> complexAlgebraicNumbersSquarefree(GenPolynomial<Complex<C>> genPolynomial) {
        ElemFactory elemFactory = genPolynomial.factory();
        if (((GenPolynomialRing)elemFactory).nvar != 1) {
            throw new IllegalArgumentException("only for univariate polynomials");
        }
        ComplexRing complexRing = (ComplexRing)((GenPolynomialRing)elemFactory).coFac;
        TermOrder termOrder = new TermOrder(2);
        GenPolynomialRing genPolynomialRing = new GenPolynomialRing(complexRing, 2, termOrder);
        GenPolynomial genPolynomial2 = genPolynomialRing.univariate(1, 1L).sum(genPolynomialRing.univariate(0, 1L).multiply(complexRing.getIMAG()));
        GenPolynomialRing genPolynomialRing2 = new GenPolynomialRing(complexRing.ring, genPolynomialRing);
        ArrayList<Complex<RealAlgebraicNumber<C>>> arrayList = new ArrayList<Complex<RealAlgebraicNumber<C>>>();
        GenPolynomial<Complex<C>> genPolynomial3 = genPolynomial;
        if (genPolynomial3.isConstant() || genPolynomial3.isZERO()) {
            return arrayList;
        }
        GenPolynomial genPolynomial4 = PolyUtil.substituteUnivariate(genPolynomial3, genPolynomial2);
        genPolynomial4 = genPolynomial4.monic();
        GenPolynomial genPolynomial5 = PolyUtil.realPartFromComplex(genPolynomialRing2, genPolynomial4);
        GenPolynomial genPolynomial6 = PolyUtil.imaginaryPartFromComplex(genPolynomialRing2, genPolynomial4);
        if (debug) {
            logger.debug((Object)("rfac = " + genPolynomialRing2.toScript()));
            logger.debug((Object)("t  = " + genPolynomial2 + ", re = " + genPolynomial5.toScript() + ", im = " + genPolynomial6.toScript()));
        }
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(genPolynomial5);
        arrayList2.add(genPolynomial6);
        Ideal ideal = new Ideal(genPolynomialRing2, arrayList2);
        List list = ideal.zeroDimRootDecomposition();
        for (IdealWithUniv idealWithUniv : list) {
            IdealWithRealAlgebraicRoots idealWithRealAlgebraicRoots = PolyUtilApp.realAlgebraicRoots(idealWithUniv);
            for (List list2 : idealWithRealAlgebraicRoots.ran) {
                RealRootTuple realRootTuple = new RealRootTuple(list2);
                RealAlgebraicRing realAlgebraicRing = new RealAlgebraicRing(idealWithUniv, realRootTuple);
                List list3 = realAlgebraicRing.generators();
                int n = list3.size();
                RealAlgebraicNumber realAlgebraicNumber = list3.get(n - 2);
                RealAlgebraicNumber realAlgebraicNumber2 = list3.get(n - 1);
                ComplexRing complexRing2 = new ComplexRing(realAlgebraicRing);
                Complex complex = new Complex(complexRing2, realAlgebraicNumber, realAlgebraicNumber2);
                arrayList.add(complex);
            }
        }
        return arrayList;
    }
}

